#include "bulletgun.h"
#include "bullet.h"

BulletGun::BulletGun(Object *parent, bool *trigger, Direction *direction, float force, float offset, int cool_down, int life, float mass, int level, const bool levels[MAXLEVELS]): Object(parent) {
	this->trigger = trigger;
	this->force = force;
	this->life = life;
	this->direction = direction;
	this->offset = offset;
	this->cool_down = cool_down;
	this->mass = mass;
	this->level = level;
	for(int i = 0; i < MAXLEVELS; i++) {
		this->levels[i] = levels[i];
	}
	temp = 0;
}

void BulletGun::stepFunc() {
	Object::stepFunc();

	if(*trigger && temp <= 0) {
		temp = cool_down;

		direction->calc();

		Atom *a = new Atom(direction->x + direction->dx * offset + direction->ix, direction->y + direction->dy * offset + direction->iy, mass, direction->dx * force + direction->ix, direction->dy * force + direction->iy, level, levels);
		new Bullet(this, a, life);
	}
	else
		temp--;
}